entry InitKernel.enter;

import "../IMPORT/register.h";
import "../IMPORT/callsys.h";
import "../IMPORT/proc.h";
import "../IMPORT/entryReg.h";

block CALL_PAL {
	abs {
		public CALL_PAL_HALT		=	0x00;
		public CALL_PAL_GETCHAR		=	0x01;
		public CALL_PAL_PUTCHAR		=	0x02;
		public CALL_PAL_FORK		=	0x03;
		public CALL_PAL_EXEC		=	0x04;
		public CALL_PAL_EXIT		=	0x05;
		public CALL_PAL_GETINPUTFILE	=	0x06;
		public CALL_PAL_SWPCTX		=	0x30;
		public CALL_PAL_TBI			=	0x33;
		public CALL_PAL_WRENT		=	0x34;
		public CALL_PAL_SWPIPL		=	0x35;
		public CALL_PAL_RDPS		=	0x36;
		public CALL_PAL_WRKGP		=	0x37;
		public CALL_PAL_WRUSP		=	0x38;
		public CALL_PAL_RDUSP		=	0x3a;
		public CALL_PAL_RETSYS		=	0x3d;
		public CALL_PAL_RTI			=	0x3f;
		}
	}

block SysExit uses proc, CALL_PAL {
	code {
	public enter:
		call_pal	CALL_PAL_HALT;
		ret;
		}
	}
	
block SysGetChar uses proc, CALL_PAL {
	code {
	public enter:
		call_pal	CALL_PAL_GETCHAR;
		ret;
		}
	}
	
block SysPutchar uses proc, CALL_PAL {
	code {
	public enter:
		mov		$a1,	$a0;
		call_pal	CALL_PAL_PUTCHAR;
		ret;
		}
	}
	
block SysHandler {
	const {
	public table:
		quad	SysExit.enter;
		quad	SysGetChar.enter;
		quad	SysPutchar.enter;
		}
	}
	
block CallSysHandler uses proc, CALL_PAL, CALLSYS {
	code {
	public enter:
		lda		$sp,	-sav1($sp);
		stq		$ra,	savRet($sp);
	body:
		cmpult	$a0,	CALLSYS_MAX,	$t0;
		blbc	$t0,	error;
		ldiq	$t0,	SysHandler.table;
		s8addq	$a0,	$t0,	$t0;
		ldq		$pv,	($t0);
		jsr		($pv);
		br		return;
	error:
		negq	1,	$v0;
	return:
		ldq		$ra,	savRet($sp);
		lda		$sp,	+sav1($sp);
		call_pal	CALL_PAL_RETSYS;
		}
	}

block InitKernel uses register, entryReg, CALL_PAL {
	code {
	public enter:
		ldiq	$a0,	CallSysHandler.enter;
		ldiq	$a1,	entSys;
		call_pal	CALL_PAL_WRENT;
		
		mov		$gp,	$a0;
		call_pal	CALL_PAL_WRKGP;
		
		call_pal	CALL_PAL_RETSYS;
		}
	}


